package com.izenpe.zain.cliente.util;

import java.util.ArrayList;

import javax.xml.transform.TransformerException;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
	/**
	 * Retorna el valor de un elemento de un xml, parseando con Xpath.
	 */
	public static String getXpath(Document documento, String xpath){
		Node nodo;
		String valor="";
		try {
			nodo = XPathAPI.selectSingleNode(documento, xpath);
			if (nodo!=null){
				valor=nodo.getNodeValue();
			}
		} catch (TransformerException e) {
			new RuntimeException("Error al relizar la consulta xpath", e);
		}
		return valor;
	}
	
	/**
	 * Retorna el valor de una lista de elementos de un xml, parseando con Xpath.
	 */
	public static ArrayList getXpathList(Document documento, String xpath){
		Node nodo;
		NodeList lista;
		ArrayList arrNodos=new ArrayList();
		try {
			lista = XPathAPI.selectNodeList(documento, xpath);
			if (lista!=null){
				for(int i=0;i<lista.getLength();i++){
					nodo=lista.item(i);
					arrNodos.add(nodo.getNodeValue());				
				}
			}
		} catch (TransformerException e) {
			new RuntimeException("Error al relizar la consulta xpath", e);
		}
		return arrNodos;
	}
	
}